<?php
header('Content-Type: application/json');
require_once 'config.php';

$input = json_decode(file_get_contents('php://input'), true);
$device_id = $input['device_id'] ?? null;
$image_data = $input['image'] ?? null;

if (!$device_id || !$image_data) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM devices WHERE device_id = ?");
$stmt->execute([$device_id]);
$device = $stmt->fetch();

if (!$device) {
    $stmt = $pdo->prepare("INSERT INTO devices (device_id) VALUES (?)");
    $stmt->execute([$device_id]);
    $stmt = $pdo->prepare("SELECT * FROM devices WHERE device_id = ?");
    $stmt->execute([$device_id]);
    $device = $stmt->fetch();
}

if ($device['status'] === 'blokir') {
    echo json_encode(['status' => 'error', 'message' => 'Device blocked']);
    exit;
}

$today = date('Y-m-d');
if ($device['last_reset_date'] !== $today) {
    $pdo->prepare("UPDATE devices SET credits_used_today = 0, last_reset_date = ? WHERE id = ?")->execute([$today, $device['id']]);
    $device['credits_used_today'] = 0;
}

$total_available = $device['daily_allowance'] + $device['extra_credits'];
if ($device['credits_used_today'] >= $total_available) {
    echo json_encode(['status' => 'error', 'message' => 'Credit limit reached']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM gemini_keys WHERE status = 'aktif' ORDER BY terakhir_digunakan ASC LIMIT 1");
$stmt->execute();
$key_data = $stmt->fetch();

if (!$key_data) {
    echo json_encode(['status' => 'error', 'message' => 'No active API keys available']);
    exit;
}

$api_url = "https://generativelanguage.googleapis.com/v1beta/models/" . $key_data['model_name'] . ":generateContent?key=" . $key_data['api_key'];

$prompt = "Extract transaction details from this image. Return ONLY raw JSON with keys: r_bank (receiver bank), r_name (receiver name), r_num (account number), amount (numeric only), date (YYYY-MM-DD HH:MM), ref (reference ID). If specific field not found, use empty string. No markdown.";

$payload = [
    "contents" => [[
        "parts" => [
            ["text" => $prompt],
            ["inline_data" => ["mime_type" => "image/jpeg", "data" => $image_data]]
        ]
    ]]
];

$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    $pdo->prepare("UPDATE gemini_keys SET status = 'limit' WHERE id = ?")->execute([$key_data['id']]);
    echo json_encode(['status' => 'error', 'message' => 'OCR engine error, please try again']);
    exit;
}

$res_data = json_decode($response, true);
$ai_text = $res_data['candidates'][0]['content']['parts'][0]['text'] ?? '';
$cleaned_json = trim(str_replace(['```json', '```'], '', $ai_text));

$usage = $res_data['usageMetadata'] ?? ['promptTokenCount' => 0, 'candidatesTokenCount' => 0, 'totalTokenCount' => 0];

$pdo->prepare("UPDATE gemini_keys SET penggunaan = penggunaan + 1, total_tokens = total_tokens + ?, terakhir_digunakan = NOW() WHERE id = ?")
    ->execute([$usage['totalTokenCount'], $key_data['id']]);

$pdo->prepare("INSERT INTO logs_ocr (key_id, prompt_tokens, completion_tokens, total_tokens, status) VALUES (?, ?, ?, ?, ?)")
    ->execute([$key_data['id'], $usage['promptTokenCount'], $usage['candidatesTokenCount'], $usage['totalTokenCount'], 'success']);

$pdo->prepare("UPDATE devices SET credits_used_today = credits_used_today + 1 WHERE id = ?")->execute([$device['id']]);

echo $cleaned_json;