<?php
require_once 'config.php';

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$total_stmt = $pdo->query("SELECT COUNT(*) FROM transaksi");
$total_rows = $total_stmt->fetchColumn();
$total_pages = ceil($total_rows / $limit);

$stmt = $pdo->prepare("SELECT * FROM transaksi ORDER BY created_at DESC LIMIT ? OFFSET ?");
$stmt->bindValue(1, $limit, PDO::PARAM_INT);
$stmt->bindValue(2, $offset, PDO::PARAM_INT);
$stmt->execute();
$transactions = $stmt->fetchAll();

$sum_stmt = $pdo->query("SELECT SUM(amount) as total_nominal, SUM(admin_fee) as total_admin FROM transaksi");
$totals = $sum_stmt->fetch();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Riwayat Transaksi - TRFBT</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body { background: #f4f7f6; }
        .card { border: none; border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        .table thead { background: #4f46e5; color: white; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
        <div class="container">
            <a class="navbar-brand" href="admin.php">TRFBT Admin</a>
            <div class="navbar-nav">
                <a class="nav-link" href="admin.php">Dashboard</a>
                <a class="nav-link active" href="history.php">Riwayat</a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card p-3 bg-white">
                    <small class="text-muted">Total Perputaran Uang</small>
                    <h4 class="text-primary">Rp <?= number_format($totals['total_nominal'], 0, ',', '.') ?></h4>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card p-3 bg-white">
                    <small class="text-muted">Total Keuntungan Admin</small>
                    <h4 class="text-success">Rp <?= number_format($totals['total_admin'], 0, ',', '.') ?></h4>
                </div>
            </div>
        </div>

        <div class="card p-4">
            <h5 class="mb-4">Data Transaksi Terkini</h5>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Toko</th>
                            <th>Bank</th>
                            <th>Rekening</th>
                            <th>Penerima</th>
                            <th>Nominal</th>
                            <th>Admin</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $t): ?>
                        <tr>
                            <td><small><?= $t['transaction_date'] ?></small></td>
                            <td><?= htmlspecialchars($t['store_name']) ?></td>
                            <td><span class="badge bg-secondary"><?= htmlspecialchars($t['bank_name']) ?></span></td>
                            <td><code><?= htmlspecialchars($t['acc_number']) ?></code></td>
                            <td><?= htmlspecialchars($t['receiver_name']) ?></td>
                            <td>Rp <?= number_format($t['amount'], 0, ',', '.') ?></td>
                            <td class="text-success">+<?= number_format($t['admin_fee'], 0, ',', '.') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <nav class="mt-4">
                <ul class="pagination justify-content-center">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                            <a class="page-link" href="history.php?page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        </div>
    </div>
</body>
</html>