<?php
require_once 'config.php';

if (isset($_POST['recharge'])) {
    $stmt = $pdo->prepare("UPDATE devices SET extra_credits = extra_credits + ? WHERE id = ?");
    $stmt->execute([$_POST['amount'], $_POST['device_id']]);
    header("Location: admin.php?status=success");
    exit;
}

if (isset($_GET['toggle_key'])) {
    $stmt = $pdo->prepare("UPDATE gemini_keys SET status = IF(status='aktif', 'limit', 'aktif') WHERE id = ?");
    $stmt->execute([$_GET['toggle_key']]);
    header("Location: admin.php");
    exit;
}

$stats_transaksi = $pdo->query("SELECT COUNT(*) as total FROM transaksi")->fetch()['total'];
$stats_devices = $pdo->query("SELECT COUNT(*) as total FROM devices")->fetch()['total'];
$stats_keys = $pdo->query("SELECT COUNT(*) as total FROM gemini_keys WHERE status='aktif'")->fetch()['total'];

$devices = $pdo->query("SELECT * FROM devices ORDER BY created_at DESC")->fetchAll();
$keys = $pdo->query("SELECT * FROM gemini_keys ORDER BY penggunaan DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>TRFBT Admin Panel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body { background: #f4f7f6; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .card { border: none; border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        .stat-card { background: linear-gradient(45deg, #4f46e5, #3730a3); color: white; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark mb-4">
        <div class="container">
            <span class="navbar-brand mb-0 h1">TRFBT Admin System</span>
        </div>
    </nav>

    <div class="container">
        <div class="row mb-4 text-center">
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <h6>Total Transaksi</h6>
                    <h2><?= $stats_transaksi ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <h6>Perangkat Terdaftar</h6>
                    <h2><?= $stats_devices ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <h6>API Key Aktif</h6>
                    <h2><?= $stats_keys ?></h2>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card p-4 mb-4">
                    <h5 class="mb-4">Daftar Perangkat & Credit</h5>
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Device ID</th>
                                    <th>Harian</th>
                                    <th>Extra</th>
                                    <th>Terpakai</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($devices as $d): ?>
                                <tr>
                                    <td><small class="text-muted"><?= $d['device_id'] ?></small></td>
                                    <td><?= $d['daily_allowance'] ?></td>
                                    <td class="text-primary fw-bold"><?= $d['extra_credits'] ?></td>
                                    <td><?= $d['credits_used_today'] ?></td>
                                    <td>
                                        <form method="POST" class="d-flex gap-2">
                                            <input type="hidden" name="device_id" value="<?= $d['id'] ?>">
                                            <input type="number" name="amount" class="form-control form-control-sm" placeholder="Jumlah" required style="width:80px">
                                            <button type="submit" name="recharge" class="btn btn-success btn-sm">Isi</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card p-4">
                    <h5 class="mb-4">Rotator API Keys</h5>
                    <div class="list-group">
                        <?php foreach ($keys as $k): ?>
                        <div class="list-group-item">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1 text-truncate" style="max-width: 150px;"><?= $k['api_key'] ?></h6>
                                <span class='badge <?= $k['status'] == 'aktif' ? 'bg-success' : 'bg-danger' ?>'><?= $k['status'] ?></span>
                            </div>
                            <small class="text-muted">Total: <?= $k['total_tokens'] ?> tokens | <?= $k['penggunaan'] ?>x</small>
                            <div class="mt-2">
                                <a href="admin.php?toggle_key=<?= $k['id'] ?>" class="btn btn-outline-secondary btn-sm w-100">Toggle Status</a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>